/* Table to ease conversion of exponants from decimal to binary format

   Copyright (C) 2006 IBM Corporation.
   Copyright (C) 2007-2015 Free Software Foundation, Inc.

   This file is part of the Decimal Floating Point C Library.

   Author(s): Steve Munroe <sjmunroe@us.ibm.com>

   The Decimal Floating Point C Library is free software; you can
   redistribute it and/or modify it under the terms of the GNU Lesser
   General Public License version 2.1.

   The Decimal Floating Point C Library is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
   the GNU Lesser General Public License version 2.1 for more details.

   You should have received a copy of the GNU Lesser General Public
   License version 2.1 along with the Decimal Floating Point C Library;
   if not, write to the Free Software Foundation, Inc., 51 Franklin
   Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Please see dfp/COPYING.txt for more information.  */

#include <float.h>

#if defined(__powerpc64__) && __LDBL_MANT_DIG__ == 113
typedef __ibm128 ldouble;
#else
typedef long double ldouble;
#endif

const ldouble binpowof10 [] =
        {
        1e+00L,  /* 10**0 */
        1e+01L,  /* 10**1 */
        1e+02L,  /* 10**2 */
        1e+03L,  /* 10**3 */
        1e+04L,  /* 10**4 */
        1e+05L,  /* 10**5 */
        1e+06L,  /* 10**6 */
        1e+07L,  /* 10**7 */
        1e+08L,  /* 10**8 */
        1e+09L,  /* 10**9 */
        1e+10L,  /* 10**10 */
        1e+11L,  /* 10**11 */
        1e+12L,  /* 10**12 */
        1e+13L,  /* 10**13 */
        1e+14L,  /* 10**14 */
        1e+15L,  /* 10**15 */
        1e+16L,  /* 10**16 */
        1e+17L,  /* 10**17 */
        1e+18L,  /* 10**18 */
        1e+19L,  /* 10**19 */
        1e+20L,  /* 10**20 */
        1e+21L,  /* 10**21 */
        1e+22L,  /* 10**22 */
        1e+23L,  /* 10**23 */
        1e+24L,  /* 10**24 */
        1e+25L,  /* 10**25 */
        1e+26L,  /* 10**26 */
        1e+27L,  /* 10**27 */
        1e+28L,  /* 10**28 */
        1e+29L,  /* 10**29 */
        1e+30L,  /* 10**30 */
        1e+31L,  /* 10**31 */
        1e+32L,  /* 10**32 */
        1e+33L,  /* 10**33 */
        1e+34L,  /* 10**34 */
        1e+35L,  /* 10**35 */
        1e+36L,  /* 10**36 */
        1e+37L,  /* 10**37 */
        1e+38L,  /* 10**38 */
        1e+39L,  /* 10**39 */
        1e+40L,  /* 10**40 */
        1e+41L,  /* 10**41 */
        1e+42L,  /* 10**42 */
        1e+43L,  /* 10**43 */
        1e+44L,  /* 10**44 */
        1e+45L,  /* 10**45 */
        1e+46L,  /* 10**46 */
        1e+47L,  /* 10**47 */
        1e+48L,  /* 10**48 */
        1e+49L,  /* 10**49 */
        1e+50L,  /* 10**50 */
        1e+51L,  /* 10**51 */
        1e+52L,  /* 10**52 */
        1e+53L,  /* 10**53 */
        1e+54L,  /* 10**54 */
        1e+55L,  /* 10**55 */
        1e+56L,  /* 10**56 */
        1e+57L,  /* 10**57 */
        1e+58L,  /* 10**58 */
        1e+59L,  /* 10**59 */
        1e+60L,  /* 10**60 */
        1e+61L,  /* 10**61 */
        1e+62L,  /* 10**62 */
        1e+63L,  /* 10**63 */
        1e+64L,  /* 10**64 */
        1e+65L,  /* 10**65 */
        1e+66L,  /* 10**66 */
        1e+67L,  /* 10**67 */
        1e+68L,  /* 10**68 */
        1e+69L,  /* 10**69 */
        1e+70L,  /* 10**70 */
        1e+71L,  /* 10**71 */
        1e+72L,  /* 10**72 */
        1e+73L,  /* 10**73 */
        1e+74L,  /* 10**74 */
        1e+75L,  /* 10**75 */
        1e+76L,  /* 10**76 */
        1e+77L,  /* 10**77 */
        1e+78L,  /* 10**78 */
        1e+79L,  /* 10**79 */
        1e+80L,  /* 10**80 */
        1e+81L,  /* 10**81 */
        1e+82L,  /* 10**82 */
        1e+83L,  /* 10**83 */
        1e+84L,  /* 10**84 */
        1e+85L,  /* 10**85 */
        1e+86L,  /* 10**86 */
        1e+87L,  /* 10**87 */
        1e+88L,  /* 10**88 */
        1e+89L,  /* 10**89 */
        1e+90L,  /* 10**90 */
        1e+91L,  /* 10**91 */
        1e+92L,  /* 10**92 */
        1e+93L,  /* 10**93 */
        1e+94L,  /* 10**94 */
        1e+95L,  /* 10**95 */
        1e+96L,  /* 10**96 */
        1e+97L,  /* 10**97 */
        1e+98L,  /* 10**98 */
        1e+99L,  /* 10**99 */
        1e+100L, /* 10**100 */
        1e+101L, /* 10**101 */
        1e+102L, /* 10**102 */
        1e+103L, /* 10**103 */
        1e+104L, /* 10**104 */
        1e+105L, /* 10**105 */
        1e+106L, /* 10**106 */
        1e+107L, /* 10**107 */
        1e+108L, /* 10**108 */
        1e+109L, /* 10**109 */
        1e+110L, /* 10**110 */
        1e+111L, /* 10**111 */
        1e+112L, /* 10**112 */
        1e+113L, /* 10**113 */
        1e+114L, /* 10**114 */
        1e+115L, /* 10**115 */
        1e+116L, /* 10**116 */
        1e+117L, /* 10**117 */
        1e+118L, /* 10**118 */
        1e+119L, /* 10**119 */
        1e+120L, /* 10**120 */
        1e+121L, /* 10**121 */
        1e+122L, /* 10**122 */
        1e+123L, /* 10**123 */
        1e+124L, /* 10**124 */
        1e+125L, /* 10**125 */
        1e+126L, /* 10**126 */
        1e+127L, /* 10**127 */
        1e+128L, /* 10**128 */
        1e+129L, /* 10**129 */
        1e+130L, /* 10**130 */
        1e+131L, /* 10**131 */
        1e+132L, /* 10**132 */
        1e+133L, /* 10**133 */
        1e+134L, /* 10**134 */
        1e+135L, /* 10**135 */
        1e+136L, /* 10**136 */
        1e+137L, /* 10**137 */
        1e+138L, /* 10**138 */
        1e+139L, /* 10**139 */
        1e+140L, /* 10**140 */
        1e+141L, /* 10**141 */
        1e+142L, /* 10**142 */
        1e+143L, /* 10**143 */
        1e+144L, /* 10**144 */
        1e+145L, /* 10**145 */
        1e+146L, /* 10**146 */
        1e+147L, /* 10**147 */
        1e+148L, /* 10**148 */
        1e+149L, /* 10**149 */
        1e+150L, /* 10**150 */
        1e+151L, /* 10**151 */
        1e+152L, /* 10**152 */
        1e+153L, /* 10**153 */
        1e+154L, /* 10**154 */
        1e+155L, /* 10**155 */
        1e+156L, /* 10**156 */
        1e+157L, /* 10**157 */
        1e+158L, /* 10**158 */
        1e+159L, /* 10**159 */
        1e+160L, /* 10**160 */
        1e+161L, /* 10**161 */
        1e+162L, /* 10**162 */
        1e+163L, /* 10**163 */
        1e+164L, /* 10**164 */
        1e+165L, /* 10**165 */
        1e+166L, /* 10**166 */
        1e+167L, /* 10**167 */
        1e+168L, /* 10**168 */
        1e+169L, /* 10**169 */
        1e+170L, /* 10**170 */
        1e+171L, /* 10**171 */
        1e+172L, /* 10**172 */
        1e+173L, /* 10**173 */
        1e+174L, /* 10**174 */
        1e+175L, /* 10**175 */
        1e+176L, /* 10**176 */
        1e+177L, /* 10**177 */
        1e+178L, /* 10**178 */
        1e+179L, /* 10**179 */
        1e+180L, /* 10**180 */
        1e+181L, /* 10**181 */
        1e+182L, /* 10**182 */
        1e+183L, /* 10**183 */
        1e+184L, /* 10**184 */
        1e+185L, /* 10**185 */
        1e+186L, /* 10**186 */
        1e+187L, /* 10**187 */
        1e+188L, /* 10**188 */
        1e+189L, /* 10**189 */
        1e+190L, /* 10**190 */
        1e+191L, /* 10**191 */
        1e+192L, /* 10**192 */
        1e+193L, /* 10**193 */
        1e+194L, /* 10**194 */
        1e+195L, /* 10**195 */
        1e+196L, /* 10**196 */
        1e+197L, /* 10**197 */
        1e+198L, /* 10**198 */
        1e+199L, /* 10**199 */
        1e+200L, /* 10**200 */
        1e+201L, /* 10**201 */
        1e+202L, /* 10**202 */
        1e+203L, /* 10**203 */
        1e+204L, /* 10**204 */
        1e+205L, /* 10**205 */
        1e+206L, /* 10**206 */
        1e+207L, /* 10**207 */
        1e+208L, /* 10**208 */
        1e+209L, /* 10**209 */
        1e+210L, /* 10**210 */
        1e+211L, /* 10**211 */
        1e+212L, /* 10**212 */
        1e+213L, /* 10**213 */
        1e+214L, /* 10**214 */
        1e+215L, /* 10**215 */
        1e+216L, /* 10**216 */
        1e+217L, /* 10**217 */
        1e+218L, /* 10**218 */
        1e+219L, /* 10**219 */
        1e+220L, /* 10**220 */
        1e+221L, /* 10**221 */
        1e+222L, /* 10**222 */
        1e+223L, /* 10**223 */
        1e+224L, /* 10**224 */
        1e+225L, /* 10**225 */
        1e+226L, /* 10**226 */
        1e+227L, /* 10**227 */
        1e+228L, /* 10**228 */
        1e+229L, /* 10**229 */
        1e+230L, /* 10**230 */
        1e+231L, /* 10**231 */
        1e+232L, /* 10**232 */
        1e+233L, /* 10**233 */
        1e+234L, /* 10**234 */
        1e+235L, /* 10**235 */
        1e+236L, /* 10**236 */
        1e+237L, /* 10**237 */
        1e+238L, /* 10**238 */
        1e+239L, /* 10**239 */
        1e+240L, /* 10**240 */
        1e+241L, /* 10**241 */
        1e+242L, /* 10**242 */
        1e+243L, /* 10**243 */
        1e+244L, /* 10**244 */
        1e+245L, /* 10**245 */
        1e+246L, /* 10**246 */
        1e+247L, /* 10**247 */
        1e+248L, /* 10**248 */
        1e+249L, /* 10**249 */
        1e+250L, /* 10**250 */
        1e+251L, /* 10**251 */
        1e+252L, /* 10**252 */
        1e+253L, /* 10**253 */
        1e+254L, /* 10**254 */
        1e+255L, /* 10**255 */
        1e+256L, /* 10**256 */
        1e+257L, /* 10**257 */
        1e+258L, /* 10**258 */
        1e+259L, /* 10**259 */
        1e+260L, /* 10**260 */
        1e+261L, /* 10**261 */
        1e+262L, /* 10**262 */
        1e+263L, /* 10**263 */
        1e+264L, /* 10**264 */
        1e+265L, /* 10**265 */
        1e+266L, /* 10**266 */
        1e+267L, /* 10**267 */
        1e+268L, /* 10**268 */
        1e+269L, /* 10**269 */
        1e+270L, /* 10**270 */
        1e+271L, /* 10**271 */
        1e+272L, /* 10**272 */
        1e+273L, /* 10**273 */
        1e+274L, /* 10**274 */
        1e+275L, /* 10**275 */
        1e+276L, /* 10**276 */
        1e+277L, /* 10**277 */
        1e+278L, /* 10**278 */
        1e+279L, /* 10**279 */
        1e+280L, /* 10**280 */
        1e+281L, /* 10**281 */
        1e+282L, /* 10**282 */
        1e+283L, /* 10**283 */
        1e+284L, /* 10**284 */
        1e+285L, /* 10**285 */
        1e+286L, /* 10**286 */
        1e+287L, /* 10**287 */
        1e+288L, /* 10**288 */
        1e+289L, /* 10**289 */
        1e+290L, /* 10**290 */
        1e+291L, /* 10**291 */
        1e+292L, /* 10**292 */
        1e+293L, /* 10**293 */
        1e+294L, /* 10**294 */
        1e+295L, /* 10**295 */
        1e+296L, /* 10**296 */
        1e+297L, /* 10**297 */
        1e+298L, /* 10**298 */
        1e+299L, /* 10**299 */
        1e+300L, /* 10**300 */
        1e+301L, /* 10**301 */
        1e+302L, /* 10**302 */
        1e+303L, /* 10**303 */
        1e+304L, /* 10**304 */
        1e+305L, /* 10**305 */
        1e+306L, /* 10**306 */
        1e+307L, /* 10**307 */
        1e+308L};/* 10**308 */
/* Long Double only supports exponent up to 308.  */

/* Is this really necessary?  */
/* weak_alias(binpowof10, __dfp_binpowof10)  */
